# Introduction to Agile at Zipcode Wilmington
## What is Agile?

#### Agile software development is an umbrella term for a set of frameworks and practices based on the values and principles expressed in the Manifesto for Agile Software Development.

#### The focus is on the engineers doing the work and the manner in which they work together to deliver working software. 

#### At Zipcode Wilmington, Agile is the marriage of ProDev and Java/Data programs.


## Successful Technical Teams

#### Technical teams at Zipcode Wilmington, as well as in the greater software engineering industry, are made up of engineers who work together to deliver a working software product.

#### At Zipcode Wilmington, the software product may be a lab, a project, or an application.

#### Each team member on an Agile team is an owner of the work the team is doing. Each team member is responsible to other team members. So, it is crucial that engineers conduct themselves with professionalism and humility.
 
#### Some Agile team characteristics we will practice:

+ Every team member contributes their talents
+ No individual talent makes a team member a better leader
+ No individual talent makes a team member’s opinion more important
+ Every team member is responsible for leading the team
+ No team member cedes their leadership responsibilities to another team member


## Agile Manifesto

#### Look online for the Agile Manifesto. This is the software engineers' creed.

#### In shorthand, the manifesto tenets are:

+ Continuously deliver what is asked for
+ Welcome change; be flexible; be agile!
+ Deliver working software frequently in sprints or cycles
+ Daily standups; engineers and stakeholders are on the same team
+ Every team member is an owner and a leader; lift each other!
+ Face-to-face communication; set policies together; don’t hide behind emails and texts when you need to discuss things
+ Working software is imperative; committed code compiles
+ No one is idle; team maintains a sustainable pace
+ Commit to technical excellence and design: UML, task breakout, planning, Git best practices, paired programming
+ Keep it simple; break out tasks; remove waste
+ Self-organizing teams; every voice is used and heard
+ At regular intervals, do a retrospective

## Engineering Agile Practices
#### There are many practices software engineers use in the industry.  At Zipcode Wilmington, there is a subset of those practices you will use during the program:

+ Set and abide by policies 
+ Daily Standups - Three questions (plus a battery check)
+ Brainstorm, design, plan, do task breakout together as a team
+ Use a Kanban board (see Projects in Github)
+ Remove blockers with urgency and commitment
+ Do retrospectives - Three questions

## Cohorting

#### Cohorting is being a good teammate. It's listening. It's wanting your teammate to be successful.  It's making your teammate excel. It's what Agile is all about.