This is both the Python code to access an S3 bucket and the IAM policy JSON for the bucket permissions.

An IAM policy JSON that you can attach to your AWS account to grant the necessary permissions 
for S3 bucket access:

## IAM Policy JSON for S3 Bucket Access

```json
{
    "Version": "2012-10-17",
    "Statement": [
        {
            "Sid": "ListBucketPermission",
            "Effect": "Allow",
            "Action": [
                "s3:ListBucket"
            ],
            "Resource": "arn:aws:s3:::your-bucket-name"
        },
        {
            "Sid": "ObjectLevelPermissions",
            "Effect": "Allow",
            "Action": [
                "s3:GetObject",
                "s3:PutObject",
                "s3:DeleteObject",
                "s3:GetObjectAcl"
            ],
            "Resource": "arn:aws:s3:::your-bucket-name/*"
        }
    ]
}
```

## Setup Instructions

### 1. Install Required Python Package
```bash
pip install boto3
```

### 2. Configure AWS Credentials
You have several options to configure AWS credentials:

**Option A: AWS CLI Configuration**
```bash
aws configure
```

**Option B: Environment Variables**
```bash
export AWS_ACCESS_KEY_ID=your_access_key
export AWS_SECRET_ACCESS_KEY=your_secret_key
export AWS_DEFAULT_REGION=us-east-1
```

**Option C: IAM Role (if running on EC2)**
Attach an IAM role with the above policy to your EC2 instance.

### 3. Apply the IAM Policy

Replace `your-bucket-name` in the policy JSON with your actual bucket name, then:

1. **For IAM User**: Go to IAM → Users → Select your user → Permissions → Add permissions → Create policy → JSON tab → Paste the policy
2. **For IAM Role**: Go to IAM → Roles → Select your role → Permissions → Add permissions → Create policy → JSON tab → Paste the policy

### 4. Usage
Replace `BUCKET_NAME` in the Python code with your actual bucket name and run the script.

## Policy Permission Breakdown

- **`s3:ListBucket`**: Allows listing objects in the bucket
- **`s3:GetObject`**: Allows downloading/reading objects
- **`s3:PutObject`**: Allows uploading objects
- **`s3:DeleteObject`**: Allows deleting objects
- **`s3:GetObjectAcl`**: Allows reading object ACLs (needed for some presigned URL operations)

## Security Notes

- The policy grants access only to the specified bucket
- For production use, consider adding IP restrictions or MFA requirements
- You can restrict access to specific folder paths by modifying the `Resource` ARN (e.g., `arn:aws:s3:::your-bucket-name/specific-folder/*`)

This setup will give you full programmatic access to your S3 bucket with the Python code provided!

