## One More List of Bad Habits

Also, be aware that some of these things are not actually 
related to Python but are considered to be bad practices in most of the languages (like Java).

- No comments is bad — people forget and you should comment your code. Describe **why** not _how_. 
Explain the **intent behind the code**. 
- Too many comments is also bad — you should feel the border line.
- No abstractions is bad — they didn’t develop Python for you to write Assembly-style wall of 
code with no functions and/or classes. Copy-pasting your code is **bad** — use functions when you 
catch yourself doing it.
- Too many if/else closures is bad — if that thing goes into the 6th(!) tabulation level, you know 
something isn’t right.
- Not separating logically separate blocks by spaces and empty lines is BAD — one more time, 
don’t make it look like a dead wall, spread things out!
- Bad variables and function names are bad — _you will be surprised how many comment-writing you 
can avoid when you start naming your functions well…_
- Mixing soft and hard tabs is bad — choose one side. 
Either put X spaces (which is what most IDEs doo these days) or 1 tab in place of those X spaces. 
Do not mix them up. Or expand your tabs and never think about it.
- Not using popular and well tested libraries and services and inventing the 
bicycle is OK if it is your personal project and you just want to learn but otherwise is BAD.



