# Java Control Flow: If Statements and Loops

## If Statements

### Basic If Statement
The simplest form of decision making:

```java
public class BasicIf {
    public static void main(String[] args) {
        int temperature = 28;
        
        if (temperature > 25) {
            System.out.println("It's a hot day!");
        }
        
        // Using multiple conditions
        if (temperature > 25 && temperature < 30) {
            System.out.println("Perfect weather for swimming!");
        }
    }
}
```

### If-Else Statement
When you need to handle two alternative scenarios:

```java
public class IfElse {
    public static void main(String[] args) {
        int score = 75;
        
        if (score >= 60) {
            System.out.println("You passed!");
        } else {
            System.out.println("You need to retake the test.");
        }
        
        // Using with String comparison
        String status = "Premium";
        if (status.equals("Premium")) {
            System.out.println("Access granted to premium features");
        } else {
            System.out.println("Upgrade to premium for additional features");
        }
    }
}
```

### If-Else-If Ladder
For multiple conditions:

```java
public class IfElseIf {
    public static void main(String[] args) {
        int grade = 85;
        
        if (grade >= 90) {
            System.out.println("A - Excellent!");
        } else if (grade >= 80) {
            System.out.println("B - Good job!");
        } else if (grade >= 70) {
            System.out.println("C - Satisfactory");
        } else if (grade >= 60) {
            System.out.println("D - Needs improvement");
        } else {
            System.out.println("F - Failed");
        }
    }
}
```

### Nested If Statements
Conditions within conditions:

```java
public class NestedIf {
    public static void main(String[] args) {
        boolean isLoggedIn = true;
        String userRole = "admin";
        
        if (isLoggedIn) {
            System.out.println("Welcome back!");
            
            if (userRole.equals("admin")) {
                System.out.println("You have admin privileges");
            } else {
                System.out.println("You have user privileges");
            }
        } else {
            System.out.println("Please log in first");
        }
    }
}
```

## Loops

### For Loop
Used when you know the number of iterations:

```java
public class ForLoop {
    public static void main(String[] args) {
        // Basic for loop
        for (int i = 0; i < 5; i++) {
            System.out.println("Count: " + i);
        }
        
        // Loop with multiple variables
        for (int i = 0, j = 10; i < j; i++, j--) {
            System.out.println("i = " + i + ", j = " + j);
        }
        
        // For loop with array
        int[] numbers = {1, 2, 3, 4, 5};
        for (int i = 0; i < numbers.length; i++) {
            System.out.println("Number: " + numbers[i]);
        }
    }
}
```

### Enhanced For Loop (For-Each)
Simplified loop for collections and arrays:

```java
public class EnhancedFor {
    public static void main(String[] args) {
        String[] fruits = {"Apple", "Banana", "Orange", "Mango"};
        
        for (String fruit : fruits) {
            System.out.println("Fruit: " + fruit);
        }
        
        // With ArrayList
        ArrayList<Integer> numbers = new ArrayList<>();
        numbers.add(1);
        numbers.add(2);
        numbers.add(3);
        
        for (Integer number : numbers) {
            System.out.println("Number: " + number);
        }
    }
}
```

### While Loop
Used when the number of iterations is not known in advance:

```java
public class WhileLoop {
    public static void main(String[] args) {
        int count = 0;
        
        while (count < 5) {
            System.out.println("Count: " + count);
            count++;
        }
        
        // Reading input example
        Scanner scanner = new Scanner(System.in);
        String input = "";
        
        while (!input.equals("quit")) {
            System.out.println("Enter command (type 'quit' to exit):");
            input = scanner.nextLine();
            System.out.println("You entered: " + input);
        }
    }
}
```

### Do-While Loop
Ensures the loop body executes at least once:

```java
public class DoWhile {
    public static void main(String[] args) {
        int number = 1;
        
        do {
            System.out.println("Number: " + number);
            number *= 2;
        } while (number < 100);
        
        // Menu example
        Scanner scanner = new Scanner(System.in);
        int choice;
        
        do {
            System.out.println("\n1. View profile");
            System.out.println("2. Edit settings");
            System.out.println("3. Exit");
            System.out.print("Enter your choice: ");
            
            choice = scanner.nextInt();
            
            switch (choice) {
                case 1:
                    System.out.println("Viewing profile...");
                    break;
                case 2:
                    System.out.println("Editing settings...");
                    break;
                case 3:
                    System.out.println("Goodbye!");
                    break;
                default:
                    System.out.println("Invalid choice!");
            }
        } while (choice != 3);
    }
}
```

### Control Statements in Loops
Break and continue statements:

```java
public class LoopControl {
    public static void main(String[] args) {
        // Break example
        for (int i = 0; i < 10; i++) {
            if (i == 5) {
                break;  // Exit loop when i equals 5
            }
            System.out.println("Count: " + i);
        }
        
        // Continue example
        for (int i = 0; i < 5; i++) {
            if (i == 2) {
                continue;  // Skip iteration when i equals 2
            }
            System.out.println("Number: " + i);
        }
    }
}
```

Key points to remember:
- If statements can be nested but try to avoid too many levels of nesting
- Always use curly braces for clarity, even for single-line blocks
- Choose the appropriate loop based on your needs:
  - For loop when you know the number of iterations
  - While loop when the iteration count is unknown
  - Do-while when you need at least one iteration
- Use break to exit a loop early
- Use continue to skip to the next iteration
- Be careful with infinite loops - ensure your loop condition will eventually be false

These control flow statements are fundamental to Java programming and are used extensively in real-world applications.