
_I'm struggling to see where we take the user input for the task name._

the `command` variable will have `exit` or whatever, right?

and the `new <task>` will actually look like `new Buy Milk`

so take the string and split it into a list of strings, breaking each string on the <space> character.

```python
txt = "welcome to the jungle"

x = txt.split()

print(x)

# ['welcome', 'to', 'the', 'jungle']
```

BUT Ulas says

```python
txt = "new Buy Milk"
t = txt.split()
print(t)
command = t[0]
rest = t[1:]
rest = " ".join(rest)
print(command, ' - ', rest)
```

and after hacking a bit in the python interpreter, you may end up with

```python
  line = input(prompt)
  #print(line)
  while not line:
    line = input(prompt)
  words = line.split()
  #print(words)
  command = words[0]
  #print(command)
  rest = words[1:]
  rest = " ".join(rest)
  #print(rest)
```


and maybe the right thing to do is to change the `command = input("Tasty> ")` to something like 
`command, rest = tasty.prompt_user("Tasty> ")`

then all the "words" after the "new" will be what you pull together to name the task?

so `prompt-user(self, prompt)` becomes a method which asks for the user's input
(using input(prompt))

```python
def prompt_user(self, prompt):
  inp = input(prompt)
  # lookup how to split words into words[]
```

## saving? a Hint

```python
with open("saved_data.json", "w") as fp:
  json.dump(self.tasks,fp)
```

## loading? a Hint

```python
with open(filename) as json_file:
  self.tasks = json.load(json_file)
```

And you should embed this stuff into a method.

When you get to the point where you are puzzling over how to save/load multiple dicts 
(say, _tasks_, _trash_, and _important_),
you might consider putting all this in another dictionary and just saving that.

You still have to _load_ the one dict and then split it into three for use by the methods.
This should be done in _load tasks_ method.

The data structure might be created by

```python
dict_to_save = { "tasks": self.tasks, "trash": self.trash, "impt": self.important }
```

You can now _json.dump_ the `dict_to_save` to a file.

Loading it will be the opposite, you end up with one `loaded_dicts` which 
have to be split like: `self.tasks = loaded_dicts['tasks']`


Easy Peasy