

If we have thought about this:

```python

tasks = {}   # creates an empty dictionary

tasks['Buy Milk'] = 'not yet'
tasks['Start Lab'] = 'completed'

tasks['Finish Lab'] = 'not yet'

# to test if something is done?

task_name = 'Buy Milk'

if tasks[task_name] == 'not yet':
  # task is unfinished 
else:
  # task is 'complete'

# to list all the tasks

for task_name, status in enumerate(tasks.items()):
  print("- ", task_name, status) 
```

We need to think about how to put _into the class_.
We might...

```python
class Tasty:
  
  def __init__(self):
    self.tasks = {}

  def add_task(self, task_name):
    """
    Add a new task to the user tasks.
    """
    if task_name not in self.tasks:
        self.tasks[task_name] = "not yet"
    else:
        print("Task already added.")


  def display_tasks(self):
    for task_name, status in enumerate(self.tasks.items()):
      print("- ", task_name, status)

```

See how those things went from just trial code to _methods_ in the class?







