# You need to write a loop that counts the occurrences of each word in a list.
#
# Consider, if you had a big str that was a text, like say: https://zcw.guru/kristofer/hamlet
# 
# strive to be "pythonic" in your code expressions, okay?

colors = ["red", "green", "blue", "green", "red", "green"]

# Not Pythonic Code
d = {}
for color in colors:
    if color not in d:
       d[color] = 0
    d[color] += 1

# Pythonic Code
d = {}
for color in colors:
    d[color] = d.get(color, 0) + 1 # notice, no need for if

# Another Pythonic Code
from collections import defaultdict
d = defaultdict(int)
for color in colors:
    d[color] += 1

# code output
# {'red': 2, 'green': 3, 'blue': 1}