import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Scanner;

public class ArrayListExamples {

    public static void main(String[] args) {
        // Example 1: Student Management System
        studentManagementSystem();
        
        System.out.println("\n-----------------------------------\n");
        
        // Example 2: Shopping Cart Implementation
        shoppingCartExample();
    }
    
    /**
     * Example 1: Student Management System
     * Demonstrates adding, removing, searching, and sorting students
     */
    public static void studentManagementSystem() {
        System.out.println("STUDENT MANAGEMENT SYSTEM EXAMPLE");
        
        // Create an ArrayList to store student names
        ArrayList<String> students = new ArrayList<>();
        
        // Add students to the list
        students.add("Emma Johnson");
        students.add("Liam Smith");
        students.add("Olivia Williams");
        students.add("Noah Brown");
        students.add("Ava Jones");
        
        // Display all students
        System.out.println("Current Students:");
        for (int i = 0; i < students.size(); i++) {
            System.out.println((i + 1) + ". " + students.get(i));
        }
        
        // Add a new student at a specific position (third position)
        students.add(2, "Mason Davis");
        System.out.println("\nAfter adding Mason Davis at position 3:");
        displayList(students);
        
        // Check if a student exists
        String searchName = "Ava Jones";
        if (students.contains(searchName)) {
            System.out.println("\nFound student: " + searchName);
            System.out.println("Position: " + (students.indexOf(searchName) + 1));
        } else {
            System.out.println("\nStudent not found: " + searchName);
        }
        
        // Remove a student
        students.remove("Noah Brown");
        System.out.println("\nAfter removing Noah Brown:");
        displayList(students);
        
        // Sort students alphabetically
        Collections.sort(students);
        System.out.println("\nAlphabetically sorted students:");
        displayList(students);
        
        // Clear the entire list
        students.clear();
        System.out.println("\nAfter clearing the list, size: " + students.size());
    }
    
    /**
     * Example 2: Shopping Cart Implementation
     * Demonstrates a more complex ArrayList with custom objects
     */
    public static void shoppingCartExample() {
        System.out.println("SHOPPING CART EXAMPLE");
        
        // Create an ArrayList of items
        ArrayList<CartItem> cart = new ArrayList<>();
        
        // Add items to cart
        cart.add(new CartItem("Laptop", 899.99, 1));
        cart.add(new CartItem("Mouse", 24.99, 1));
        cart.add(new CartItem("Keyboard", 59.99, 1));
        cart.add(new CartItem("USB Drive", 19.99, 2));
        
        // Display cart contents
        System.out.println("Shopping Cart Contents:");
        displayCart(cart);
        
        // Calculate and display total
        double total = 0;
        for (CartItem item : cart) {
            total += item.getPrice() * item.getQuantity();
        }
        System.out.printf("\nCart Total: $%.2f\n", total);
        
        // Update quantity of an item
        for (CartItem item : cart) {
            if (item.getName().equals("USB Drive")) {
                item.setQuantity(3);
                System.out.println("\nUpdated USB Drive quantity to 3");
                break;
            }
        }
        
        // Display updated cart and total
        System.out.println("\nUpdated Shopping Cart:");
        displayCart(cart);
        
        // Recalculate total
        total = 0;
        for (CartItem item : cart) {
            total += item.getPrice() * item.getQuantity();
        }
        System.out.printf("\nNew Cart Total: $%.2f\n", total);
        
        // Sort by price (using Comparator)
        Collections.sort(cart, new Comparator<CartItem>() {
            @Override
            public int compare(CartItem item1, CartItem item2) {
                return Double.compare(item1.getPrice(), item2.getPrice());
            }
        });
        
        System.out.println("\nCart Items Sorted by Price (Low to High):");
        displayCart(cart);
        
        // Remove an item
        cart.removeIf(item -> item.getName().equals("Mouse"));
        System.out.println("\nAfter removing Mouse:");
        displayCart(cart);
    }
    
    // Helper method to display a list of strings
    private static void displayList(ArrayList<String> list) {
        for (int i = 0; i < list.size(); i++) {
            System.out.println((i + 1) + ". " + list.get(i));
        }
    }
    
    // Helper method to display cart items
    private static void displayCart(ArrayList<CartItem> cart) {
        for (int i = 0; i < cart.size(); i++) {
            CartItem item = cart.get(i);
            System.out.printf("%d. %-10s $%.2f x %d = $%.2f\n", 
                    i + 1, 
                    item.getName(), 
                    item.getPrice(), 
                    item.getQuantity(),
                    item.getPrice() * item.getQuantity());
        }
    }
}

/**
 * Class representing an item in a shopping cart
 */
class CartItem {
    private String name;
    private double price;
    private int quantity;
    
    public CartItem(String name, double price, int quantity) {
        this.name = name;
        this.price = price;
        this.quantity = quantity;
    }
    
    public String getName() {
        return name;
    }
    
    public double getPrice() {
        return price;
    }
    
    public int getQuantity() {
        return quantity;
    }
    
    public void setQuantity(int quantity) {
        this.quantity = quantity;
    }
}