I'll share some practical examples of using the ArrayList class in Java, focusing on different real-world scenarios.

These examples demonstrate two common use cases for ArrayLists in Java:

### Example 1: Student Management System
The first example shows how to use an ArrayList to manage a list of students, demonstrating:
- Adding students to the list
- Inserting a student at a specific position
- Searching for students
- Removing students
- Sorting the list alphabetically
- Clearing the entire list

### Example 2: Shopping Cart Implementation
The second example is more complex, using an ArrayList to manage a shopping cart with custom objects:
- Creating and storing custom objects (CartItem class)
- Calculating totals from the items in the list
- Finding and updating specific items in the list
- Sorting items by price using a Comparator
- Removing items conditionally with the removeIf() method

These examples showcase the flexibility of ArrayList and how it can be used to manage both simple collections of strings and more complex collections of custom objects. Each example includes helpful methods for displaying the current state of the list, making it easier to understand how ArrayLists work in practice.

