# Introduction to Java Programming

## 1. Basic Program Structure
Every Java program starts with a class, and the main method is the entry point of the program. Here's a simple example:

```java
public class HelloWorld {
    public static void main(String[] args) {
        System.out.println("Hello, World!");
    }
}
```

This structure is fundamental to Java:
- `public class`: Declares a class that can be accessed from anywhere
- `static void main(String[] args)`: The main method that runs when you execute the program
- `System.out.println()`: Prints text to the console

## 2. Variables and Data Types
Java is a strongly-typed language, meaning you must declare the type of each variable. Here are the basic data types:

```java
public class Variables {
    public static void main(String[] args) {
        // Numeric types
        int age = 25;                    // Whole numbers
        double price = 19.99;            // Decimal numbers
        
        // Text
        char grade = 'A';                // Single character
        String name = "John Doe";        // Text string
        
        // Boolean
        boolean isStudent = true;        // true or false
        
        // Printing variables
        System.out.println("Name: " + name);
        System.out.println("Age: " + age);
        System.out.println("Grade: " + grade);
    }
}
```

## 3. Control Flow Statements
Control flow statements help you make decisions and repeat actions in your code.

### If-Else Statements
```java
public class ControlFlow {
    public static void main(String[] args) {
        int score = 85;
        
        if (score >= 90) {
            System.out.println("Excellent!");
        } else if (score >= 80) {
            System.out.println("Good job!");
        } else {
            System.out.println("Keep practicing!");
        }
    }
}
```

### Loops
```java
public class Loops {
    public static void main(String[] args) {
        // For loop
        System.out.println("Counting with for loop:");
        for (int i = 1; i <= 5; i++) {
            System.out.println("Count: " + i);
        }
        
        // While loop
        System.out.println("\nCounting with while loop:");
        int count = 1;
        while (count <= 5) {
            System.out.println("Count: " + count);
            count++;
        }
    }
}
```

## 4. Arrays
Arrays allow you to store multiple values of the same type:

```java
public class ArrayExample {
    public static void main(String[] args) {
        // Declaring and initializing an array
        int[] numbers = {1, 2, 3, 4, 5};
        
        // Accessing array elements
        System.out.println("First number: " + numbers[0]);
        
        // Array iteration
        System.out.println("\nAll numbers:");
        for (int number : numbers) {
            System.out.println(number);
        }
        
        // Creating an array of strings
        String[] fruits = new String[3];
        fruits[0] = "Apple";
        fruits[1] = "Banana";
        fruits[2] = "Orange";
        
        System.out.println("\nFruits:");
        for (String fruit : fruits) {
            System.out.println(fruit);
        }
    }
}
```

## 5. Methods
Methods help you organize code into reusable blocks:

```java
public class Methods {
    public static void main(String[] args) {
        // Calling methods
        greet("Alice");
        int sum = add(5, 3);
        System.out.println("Sum: " + sum);
    }
    
    // Method with no return value (void)
    public static void greet(String name) {
        System.out.println("Hello, " + name + "!");
    }
    
    // Method that returns a value
    public static int add(int a, int b) {
        return a + b;
    }
}
```

These examples cover the fundamental concepts you'll need to start programming in Java. Remember to:
- Save each class in a separate file with the same name as the class
- Compile your code using `javac FileName.java`
- Run your program using `java FileName`

Practice with these examples and modify them to experiment with different values and behaviors. This hands-on experience will help solidify your understanding of Java basics.