# example of memoization in python for fibonacci

# Memoization: Let’s Be Efficient, Shall We?
# Ever worry about recursion and the stack and so on...
# Ever ask the same question over and over? 
# Annoying, right? That’s what your computer thinks too. 
# Memoization fixes this by storing results so you don’t have to repeat expensive calculations.
def fib(n, memo={}):
    if n in memo:
        return memo[n]
    if n < 2:
        return n
    memo[n] = fib(n - 1, memo) + fib(n - 2, memo)
    return memo[n]

fib(100)

# 354224848179261915075
