# Python - your new BFF

Python needs to be your _new, best, friend._

Python, an intuitive and versatile programming language, has earned its reputation as the go-to language for 
beginners and experts alike. Its simplicity and readability make it accessible to newcomers, while its extensive 
libraries and frameworks provide powerful tools for complex projects. 

Regularly revisiting the essentials and fundamentals of Python is crucial for both learning and mastery. 
It is crucial to having a strong foundation that ensures that you remain adept at problem-solving, efficient 
coding practices, and leveraging the latest updates and features. This periodic review helps keep skills sharp
and knowledge current, paving the way for continual growth and innovation.

## Python for Data Engineers

Wes McKinney's Book [Python for Data Analysis, 3E](https://wesmckinney.com/book/) has a good couple of chapters of _python review._

- [2  Python Language Basics, IPython, and Jupyter Notebooks](https://wesmckinney.com/book/python-basics)
- [3  Built-In Data Structures, Functions, and Files](https://wesmckinney.com/book/python-builtin)

and the code notebooks for these two chapters:

- [2 ch02.ipynb](https://github.com/wesm/pydata-book/blob/3rd-edition/ch02.ipynb)
- [3 ch03.ipynb](https://github.com/wesm/pydata-book/blob/3rd-edition/ch03.ipynb)


Are very Handy.

## ZipCode's Python

ZCW also has a series of articles and slides which roughly mirror the outline of Allen Downey's [ThinkPython, 2E](https://greenteapress.com/thinkpython2/html/index.html)

- [Part 1, Types, Operators, Strings, Comments](https://zipcodecore.github.io/curriculum-assets/lectures/python/types-operators-strings-comments/content.html)
- [Part 2, Input, Functions (and Lambdas)](https://zipcodecore.github.io/curriculum-assets/lectures/python/functions/content.html)
- [Part 3, Expressions, Conditionals](https://zipcodecore.github.io/curriculum-assets/lectures/python/conditional-operators/content.html)
- [Part 4, Range, Loops, and Control Flow & Recursion](https://zipcodecore.github.io/curriculum-assets/lectures/python/recursion-and-loops/content.html)
- [Part 5, Strings & Lists](https://zipcodecore.github.io/curriculum-assets/lectures/python/strings/content.html)
- [Part6, Tuples & Zip](https://zipcodecore.github.io/curriculum-assets/lectures/python/tuples/content.html)
- [Part 7, Dictionaries](https://zipcodecore.github.io/curriculum-assets/lectures/python/dictionaries/content.html)
- [Part 8, OS Module and Exception Handling](https://zipcodecore.github.io/curriculum-assets/lectures/python/os-module/content.html)
- [Part 9, Persistence](https://zipcodecore.github.io/curriculum-assets/lectures/python/persistence/content.html)
- [Part 10, Classes and Objects](https://zipcodecore.github.io/curriculum-assets/lectures/python/classes/content.html)
- [Part 11, Inheritance](https://zipcodecore.github.io/curriculum-assets/lectures/python/inheritance/content.html)
- [Part 12, Conditional Expressions, Comprehensions, and Generators](https://zipcodecore.github.io/curriculum-assets/lectures/python/conditional-expressions/content.html)

## And some Real references 

- Easy to Learn
  - [Think Python Ebook](https://greenteapress.com/wp/think-python-2e/)
- Thoroughly documented
  - [Python Docs](https://www.python.org/doc/)
- Open source
  - [Wiki Entry](https://en.wikipedia.org/wiki/Open_source)
- Broad range of applications
  - [Applications](https://www.python.org/about/apps/)
- Fully featured standard library
  - [Python Standard Library Docs](https://docs.python.org/3/)
- Thousands of third-party modules
  - [Python Package Index (PyPI)](https://pypi.org/)

