# Java Variables, Operators, and Types

## Primitive Data Types
Java has eight primitive data types that store simple values. Here's a comprehensive overview:

```java
public class PrimitiveTypes {
    public static void main(String[] args) {
        // Integer types
        byte smallNumber = 127;          // 8-bit, range: -128 to 127
        short mediumNumber = 32000;      // 16-bit, range: -32,768 to 32,767
        int standardNumber = 2000000000; // 32-bit, range: ~-2B to ~2B
        long bigNumber = 9000000000L;    // 64-bit, needs 'L' suffix
        
        // Floating-point types
        float decimalNumber = 3.14f;     // 32-bit, needs 'f' suffix
        double preciseNumber = 3.14159;  // 64-bit, default for decimals
        
        // Character type
        char letter = 'A';               // 16-bit Unicode character
        
        // Boolean type
        boolean isActive = true;         // true or false
    }
}
```

## Variable Declaration and Initialization

Variables can be declared and initialized in several ways:

```java
public class VariableDeclaration {
    public static void main(String[] args) {
        // Single declaration
        int age;
        age = 25;
        
        // Declaration with initialization
        String name = "John";
        
        // Multiple declarations
        int x, y, z;
        x = 1; y = 2; z = 3;
        
        // Multiple declarations with initialization
        double height = 5.9, weight = 68.5;
        
        // Constants (final variables)
        final double PI = 3.14159;
        final int MAX_USERS = 100;
    }
}
```

## Type Conversion and Casting

Java supports both implicit (automatic) and explicit (manual) type conversion:

```java
public class TypeConversion {
    public static void main(String[] args) {
        // Implicit conversion (widening)
        int smallNum = 100;
        long bigNum = smallNum;    // int to long
        float floatNum = bigNum;   // long to float
        
        // Explicit conversion (narrowing)
        double price = 99.99;
        int roundedPrice = (int) price;  // Loses decimal part
        
        // String conversion
        String strNumber = "123";
        int parsedInt = Integer.parseInt(strNumber);
        double parsedDouble = Double.parseDouble("123.45");
        
        // Converting numbers to String
        String strValue = String.valueOf(parsedInt);
        String anotherStr = Integer.toString(parsedInt);
    }
}
```

## Operators

### Arithmetic Operators
```java
public class ArithmeticOperators {
    public static void main(String[] args) {
        int a = 10, b = 3;
        
        System.out.println("Addition: " + (a + b));        // 13
        System.out.println("Subtraction: " + (a - b));     // 7
        System.out.println("Multiplication: " + (a * b));  // 30
        System.out.println("Division: " + (a / b));        // 3
        System.out.println("Modulus: " + (a % b));         // 1
        
        // Increment and decrement
        int count = 5;
        System.out.println(count++);  // Prints 5, then increments
        System.out.println(++count);  // Increments, then prints 7
    }
}
```

### Comparison Operators
```java
public class ComparisonOperators {
    public static void main(String[] args) {
        int x = 5, y = 8;
        
        System.out.println(x == y);  // Equal to: false
        System.out.println(x != y);  // Not equal to: true
        System.out.println(x > y);   // Greater than: false
        System.out.println(x < y);   // Less than: true
        System.out.println(x >= y);  // Greater than or equal: false
        System.out.println(x <= y);  // Less than or equal: true
    }
}
```

### Logical Operators
```java
public class LogicalOperators {
    public static void main(String[] args) {
        boolean isValid = true;
        boolean isActive = false;
        
        System.out.println(isValid && isActive);  // AND: false
        System.out.println(isValid || isActive);  // OR: true
        System.out.println(!isValid);             // NOT: false
        
        // Short-circuit evaluation
        int num = 10;
        if (num > 0 && num++ < 20) {
            System.out.println(num);  // Prints 11
        }
    }
}
```

### Assignment Operators
```java
public class AssignmentOperators {
    public static void main(String[] args) {
        int value = 10;
        
        value += 5;   // value = value + 5
        value -= 3;   // value = value - 3
        value *= 2;   // value = value * 2
        value /= 4;   // value = value / 4
        value %= 3;   // value = value % 3
        
        // Bitwise assignment operators
        int flags = 5;
        flags &= 3;   // Bitwise AND assignment
        flags |= 4;   // Bitwise OR assignment
        flags ^= 1;   // Bitwise XOR assignment
    }
}
```

Remember these key points about Java variables and operators:
- Variables must be declared before use
- Java is strongly typed, meaning type checking happens at compile time
- The type of a variable determines what operations can be performed on it
- Implicit type conversion only works when going from a smaller to a larger data type
- Explicit type conversion (casting) is required when going from a larger to a smaller data type
- Operators follow a specific precedence order when evaluating expressions
- Short-circuit evaluation in logical operators can improve performance

Practice with these examples to better understand how variables, types, and operators work together in Java programs.