When setting up a new shell environment, I take the following steps to create a space that literally works for me.
The command prompt tells me what machine I'm on, the path I'm in, Git status, whether the last command succeeded
or not, and its elapsed time.

Install the following:
- Ghostty on Mac, terminator on Linux
- zsh
  * brew install zsh
- Oh-my-zsh
  * sh -c "$(curl -fsSL https://raw.githubusercontent.com/ohmyzsh/ohmyzsh/master/tools/install.sh)”
- zsh plugins:
  - zsh-autosuggestions
    * cd ~/.oh-my-zsh/custom/plugins;git clone https://github.com/zsh-users/zsh-autosuggestions.git
  - zsh-syntax-highlighting
    * cd ~/.oh-my-zsh/custom/plugins;git clone https://github.com/zsh-users/zsh-syntax-highlighting.git
- Powerlevel10k -- See lorenobettini.it/2024/01/oh-my-zsh-and-powerlevel10k-in-macos/
  * git clone --depth=1 https://github.com/romkatv/powerlevel10k.git ${ZSH_CUSTOM:-$HOME/.oh-my-zsh/custom}/themes/powerlevel10k
  * In ~/.zshrc, set ZSH_THEME=“powerlevel10k/powerlevel10k”
  * source ~/.zshrc to run p10k configuration
    - When asked, install the Meslo Nerd Font
    - Restart your terminal and run p10k from scratch.

Configure the following plugins in ~/.zshrc
- git
- colored-man-pages
- virtualenv
- zsh-syntax-highlighting
- zsh-autosuggestions
